#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Mar  4 18:53:39 2021

@author: Mathilde
"""

### N'oubliez pas d'importer les modules dont vous avez besoin au début
### de votre fichier de code

import matplotlib.pyplot as plt
import time


### Q1 : Deux propositions pour la dichotomie

def dichotomie_1(fonction,a,b,epsilon):
    # En entrée, on a la fonction dont on cherche le zéro
    # [a,b] est un intervalle sur lequel la fonction s'annule
    # epsilon est la précision choisie pour la valeur approchée
    a_n=a
    b_n=b
    while b_n-a_n > epsilon:
        c=(a_n+b_n)/2
        if fonction(a)*fonction(c)<0:
            b_n=c
        else:
            a_n=c
    return((b_n+a_n)/2)
    
def dichotomie_2(fonction,u0,v0,epsilon):
    # fonction(x)=0 admet une unique solution alpha avec
    # u0<alpha<v0. epsilon est un nombre >0.
    # dichotomie renvoie une approximation de alpha avec une précision epsilon
    
    u=u0
    v=v0
    while v-u>epsilon:
        milieu=(v+u)/2
        if fonction(milieu)*fonction(u)<0:
            v=milieu
        else:
            u=milieu  
    return((u+v)/2)

### Q2: deux propositions pour Newton
  
def g(x):
    return(x**3+3*x+1) 
    
def dg(x):
    return(3*x**2+3)

def mon_newton_1(g,dg,a,epsilon):
    """
    Cette fonction donne une solution approchée de g(x)=0 à l'aide de la 
    méthode de Newton. a est une estimation de la solution. epsilon>0 est 
    la précision souhaitée pour l'approximation finale
    """
    a_n=a
    i=0
    a_nplusun=a_n-(g(a_n)/dg(a_n))
    while abs(a_nplusun-a_n)>epsilon:
        a_n=a_nplusun
        a_nplusun=a_nplusun-(g(a_nplusun)/dg(a_nplusun))
        i=i+1
    return(a_nplusun)
    
    
def mon_newton_2(f,df,u0,epsilon):
    # f est une fonction, df sa dérivée. On veut approcher la solution
    # de f(x)=0 à l'aide de la méthode de Newton.
    # uo et la première approximation, on la suppose assez proche de
    # la solution exacte pour assurer la convergence de la suite.
    # espilon>0 est la précision souhaitée
    terme=u0
    test=True
    while test:
        nouveauterme=-f(terme)/df(terme)+terme
        test=abs(terme-nouveauterme)>epsilon
        terme=nouveauterme
    return(terme)  
    
### Q4
### On va comparer le temps que met chaque méthode (dichotomie ou Newton)
### à renvoyer une solution
    
### Q5 
### On va tracer le temps de calcul en fonction de la précision pour chaque
### méthode
    
### Q6
def compareDichoNewton():
    precision=[10**(-n)for n in range(1,11)]
    Temps_dicho,Temps_Newton=[],[]
    
    for epsilon in precision:
        Debut=time.perf_counter()
        dichotomie_1(g,-1,0,epsilon)
        Fin=time.perf_counter()
        Temps_dicho.append(Fin-Debut)
        
        Debut=time.perf_counter()
        mon_newton_1(g,dg,0,epsilon)
        Fin=time.perf_counter()
        Temps_Newton.append(Fin-Debut)
        
    logPrecision=range(1,11)
    
    plt.plot(logPrecision,Temps_dicho,'-r', label="dichotomie")
    #plt.plot(logPrecision,tempsDichoRecursif,'-b', label="dichotomie récursif")
    plt.plot(logPrecision,Temps_Newton,'-g', label="Newton")
    plt.xlabel("""qualité de la précision (écart de 10^-n à la valeur "vraie")""")
    plt.ylabel("temps de calcul en s")
    plt.legend()

