#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Apr 21 08:35:51 2020

@author: keven
"""

# Question 1

def triche(T,M):
    # T et M sont deux chaînes de caractères
    # renvoie True si M est une sous-chaîne de T, False sinon
    return(M in T)


# Question 2

def auxiliaire(T,M,i):
    # T et M sont deux chaînes de caractères
    # i est un entier naturel
    # renvoie True si M est la sous-chaîne de T qui commence à T[i]
    return(M==T[i:i+len(M)])
 
    
# Question 3
#
# Le coût de auxiliaire, en nombre de comparaisons de caractères, est O(len(M)).
# En effet, au pire, on va comparer successivement les caractères de deux 
# chaînes de caractères qui ont la même longueur. Au mieux, 1 comparaison.
# Le test == est une boîte noire, peut-être est-elle optimisée, par exemple,
# pour commencer par comparer la longueur des chaînes?
#
# Notez qu'on peut régler cette question en programmant directement la 
# comparaison des caractères entre eux (et alors, c'est nous qui choisirons)
# si on inclue un test d'égalité de longueur de chaîne en amont des comparaisons
# de caractères.
    

# Question 4
    
def solution(T,M):
    # T et M sont deux chaînes de caractères
    # renvoie True si M est une sous-chaîne de T, False sinon
   
    # on calcule les longueurs une fois pour toutes
    longueurM=len(M)
    longueurT=len(T)

    # on prépare la boucle while
    on_a_trouve=False
    i=0
    
    while not(on_a_trouve) and (i+longueurM<=longueurT):
        on_a_trouve=on_a_trouve or auxiliaire(T,M,i)
        i=i+1
        # si on_a_trouve change de valeur, c'est qu'on a trouvé M dans T
        # et alors, on sort de la boucle
    
    return(on_a_trouve)
    
    
# Question 5
#
# Le coût de solution en nombre de comparaisons de caractères 
# est O(len(M)*(len(T)-len(M)))=O(len(M)*len(T)).
# En effet, au pire, M n'est pas dans T (ou bien correspond aux derniers caractères de T)
# et on a alors comparé toutes les sous-chaînes de longueur len(M) de T à M
# à M grâce à auxiliaire. Cela donne len(T)-len(M) appels de auxiliaires
# qui consomment len(M) comparaisons chacuns.
# Pour être parfaitement rigoureux, il y a en plus une comparaison d'int à
# chaque tour de boucle pour voir si on "rentre" dans le while. C'est un coût
# anecdotique ; d'un point de vue algorithmique ce n'est pas indispensable mais
# il serait peu élégant d'aller tester si M est dans T "au-delà" de T. 
    

# Question 6
#
# Le sens d'un "grand O" est un ordre de grandeur asympotique. Par exemple, 
# un polynôme sera toujours infiniment plus petit que exp au voisinage de l'infini.
# Par contre, 1000X^2 est grand devant exp pour des valeurs de x pas trop grandes!
# Avoir des algorithmes en O(len(T)) est important d'un point de vue théorique
# mais ne signifie pas, d'un point de vue pratique, que ce soient les plus
# efficaces en toutes circonstances. Pour len(M) qui devient très grand : oui ;
# pour len(M) assez grand : probablement ; pour len(M) pas très grand : ?.
# La création de programmes utilisant plusieurs algorithmes vise à utiliser
# l'algorithme le plus performant selon les paramètres donnés. 
    

# Question 7
    
def solutionBM(T,M):
    # mise en oeuvre de l'algorithme de Boyer-Moore
    # T et M sont deux chaînes de caractères
    # renvoie True si M est une sous-chaîne de T, False sinon
    
    # on calcule les longueurs une fois pour toutes
    longueurM=len(M)
    longueurT=len(T)

    trouve=False
    i=0 # i est le nombre de tour de la boucle while qui suit 
    
    while not(trouve) and ((i+1)*longueurM<longueurT) :
        i=i+1
        
        if T[i*longueurM-1] in M:
            k=0
            while not(trouve) and (k<longueurM) :
                trouve=trouve or (M==T[(i-1)*longueurM+k:i*longueurM+k])
                k=k+1
            # on a utilisé == pour tester l'égalité des chaînes
            # on pourrait tester caractère par caractère comme indiqué
            # dans le sujet
            # j'ai un peu modifié l'algorithme pour le rendtre plus lisible :
            # Si la dernière lettre de M n'est pas en position len(M)-1
            # alors M ne commence pas dans les len(M) premières lettres de T
            # et ainsi de suite.
    return(trouve)
    
    
# Question 8
    
# pour générer une chaîne de caractères aléatoire de longueur donnée
    
import random
import string
def chaineAlea(n):
    # n est un int
    # renvoie une chaîne de caractères aléatoire de taille n
    str = string.ascii_lowercase
    return ''.join(random.choice(str) for i in range(n))    

# on va comparer les temps d'execution des différentes solutions
# plusieurs comparaisons peuvent être faites : selon la taille de T, selon
# celle de M, selon le rapport des tailles...
# On choisit de faire varier la taille de T puis de choisir aléatoirement
# des chaines petites (2), moyennes (10), grandes (40) à chercher dans T
    
import time
import matplotlib.pyplot as plt


def compare():
        
    resultat=[]
    
    taille=[2,10,40] # taille des mots à chercher

    longueur=[50,100,200,400,600,800,1000] # longueur du texte
    
    for longueurT in longueur:
        
        Texte=chaineAlea(longueurT)
        
        for tailleMot in taille :
            
            mot=chaineAlea(tailleMot)
            
            tempsDebut=time.time()
            triche(Texte,mot)
            tempsTriche=time.time()-tempsDebut
    
            tempsDebut=time.time()
            solution(Texte,mot)
            tempsNaif=time.time()-tempsDebut
            
            tempsDebut=time.time()
            solutionBM(Texte,mot)
            tempsBM=time.time()-tempsDebut
    
            resultat.append([longueurT,tailleMot,[tempsTriche,tempsNaif,tempsBM]])

    # préparation des données pour l'affichage pour les mots de taille 2
    
    resultat_taille2=[[],[],[]]

    for a in resultat :
        if a[1]==2 :
            resultat_taille2[0].append(a[2][0])
            resultat_taille2[1].append(a[2][1])    
            resultat_taille2[2].append(a[2][2])    

    plt.plot(longueur, resultat_taille2[0], 'ro', label='avec in')
    plt.plot(longueur, resultat_taille2[1], 'gx', label='naif')
    plt.plot(longueur, resultat_taille2[2], 'b^', label='Boyer-Moore')

    plt.legend( loc='upper left', numpoints = 1 )
    plt.xlabel('longueur du texte')
    plt.ylabel('temps mis pour un mot de taille 2')
    plt.show()
    
    
     # préparation des données pour l'affichage pour les mots de taille 10
    
    resultat_taille10=[[],[],[]]

    for a in resultat :
        if a[1]==10 :
            resultat_taille10[0].append(a[2][0])
            resultat_taille10[1].append(a[2][1])    
            resultat_taille10[2].append(a[2][2])    

    plt.plot(longueur, resultat_taille10[0], 'ro', label='avec in')
    plt.plot(longueur, resultat_taille10[1], 'gx', label='naif')
    plt.plot(longueur, resultat_taille10[2], 'b^', label='Boyer-Moore')

    plt.legend( loc='upper left', numpoints = 1 )
    plt.xlabel('longueur du texte')
    plt.ylabel('temps mis pour un mot de taille 10')
    plt.show()
    
    
     
    resultat_taille40=[[],[],[]]

    for a in resultat :
        if a[1]==40 :
            resultat_taille40[0].append(a[2][0])
            resultat_taille40[1].append(a[2][1])    
            resultat_taille40[2].append(a[2][2])    

    plt.plot(longueur, resultat_taille40[0], 'ro', label='avec in')
    plt.plot(longueur, resultat_taille40[1], 'gx', label='naif')
    plt.plot(longueur, resultat_taille40[2], 'b^', label='Boyer-Moore')

    plt.legend( loc='upper left', numpoints = 1 )
    plt.xlabel('longueur du texte')
    plt.ylabel('temps mis pour un mot de taille 40')
    plt.show()
   